<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">
        users
    </li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('header'); ?>
    <h3><i class="fa fa-list"></i> Estructura </h3>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('tools'); ?>
    <a class="btn btn-secondary" href="<?php echo e(route('users.create')); ?>">
        <span class="fa fa-plus"></span>
    </a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class='card'>
            <div class="card-header"><?php echo e(__('Estructura')); ?></div>
            <div class="card-body">
                <div class="text-center">
                    <canvas id="tree" style="width: 1100px;height:600px"></canvas>
                </div>

            </div>
        </div>
        
    <?php $__env->stopSection(); ?>

    <?php $__env->startPush('custom-scripts'); ?>

        <script type="module">
            $(document).ready(function() {

                console.log('hola')

                const udocument = <?php echo json_encode($document, 15, 512) ?>;
                const month = 11;
                const year = 2023;

                const maxLevel = 6;
                let infoTree =  [];

                const levelColor = ['darkred','deepskyblue','limegreen','darkorange','teal','DarkOrchid'];
                const levelFont = ['23px sans-serif','21px sans-serif','19px sans-serif','17px sans-serif','15px sans-serif','12px sans-serif'];
                const levelSize = [26,24,22,20,18,16];

                

                $.ajax({
                    method: "POST",
                    async: true,
                    url: "<?php echo e(route('getTree')); ?>",
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        document: udocument,
                        month: month,
                        year: year
                    },
                    success: function(data) {


                        var canvas = document.getElementById('tree');

                        console.log(canvas.getContext);

                        if (canvas.getContext) {
                            var ctx = canvas.getContext('2d');

                            var est = data.tree;
                            //drawNode(uDocument,my,320,40,ctx,160,0);
                            // console.log(data.tree);
                            // if(udocument === userDocument){
                            //     drawUsers(est);
                            // }

                            //var x = data.tree.length;
                            var keys = [];

                            for (var number in est) {
                                keys.push(number);
                            }
                            //var x = data.tree.length;
                            var x = keys.length;

                            if (undefined == data.tree[x - 1]) {
                                var nivel = data.tree[x - 2][0].level;
                            } else {
                                var nivel = data.tree[x - 1][0].level;
                            }

                            //var nivel = data.tree[x-1][0].level;

                            // drawOwnSales(est[0][0].name,data.salesPerMonth.suma,data.salesReport.total,data.salesTReport.total,nivel);

                            // if(data.leadership){
                            //     drawLeadership(data.leadership);
                            // }

                            clearCanvas(ctx);
                            drawLines(est, ctx);
                            drawTree(est, ctx);

                        }
                    }
                })

                function clearCanvas(ctx) {
                    console.log('clear');
                    var canvas = document.getElementById('tree');
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                }

                function drawTree(data, ctx) {
                    console.log('drawTree');
                    //var ctx = canvas.getContext('2d');

                    infoTree = [];
                    var points = [];
                    var y = 40;

                    var keys = [];

                    for (var number in data) {
                        keys.push(number);
                    }

                    for (let r = 0; r < keys.length; r++) {

                        var x = 200 / (data[keys[r]].length + 1);

                        if (keys[r] >= maxLevel) {
                            return
                        }

                        if (keys[r] == Object.keys(data)[r]) {

                            for (let v = 0; v < data[keys[r]].length; v++) {
                                var xe = x * (v + 1);
                                var ye = y + (50 * r);
                                points[data[keys[r]][v].document] = {
                                    'dx': xe,
                                    'dy': ye
                                };

                                if (points[data[keys[r]][v].parent_document] !== undefined) {

                                }

                                var circle = new Path2D();
                                var nombres = data[keys[r]][v].name.split(' ');
                                var iniciales = '';

                                if (nombres[1]) {
                                    iniciales = nombres[0].substring(0, 1) + nombres[1].substring(0, 1);
                                } else {
                                    iniciales = nombres[0].substring(0, 1);
                                }

                                ctx.fillStyle = levelColor[keys[r]];
                                circle.arc(xe, ye, levelSize[keys[r]], 0, 2 * Math.PI);
                                // guardo en los paths
                                //pathsDocuments.push(e.document);


                                infoTree.push({
                                    document: data[keys[r]][v].document,
                                    name: data[keys[r]][v].name,
                                    path: circle,
                                    parent_document: data[keys[r]][v].parent_document
                                });

                                ctx.fill(circle);
                                ctx.font = levelFont[keys[r]];;
                                ctx.fillStyle = "white";
                                ctx.textAlign = "center";
                                //l1
                                ctx.fillText(iniciales, xe, ye + (levelSize[keys[r]] / 3));
                            }
                        }
                    }
                }

                function drawLines(data, ctx) {
                    console.log('drawLines');
                    //var ctx = canvas.getContext('2d');
                    var points = [];
                    var y = 40;

                    var keys = [];

                    for (var number in data) {
                        keys.push(number);
                    }
                    var html = '';

                    for (let r = 0; r < keys.length; r++) {

                        if (keys[r] >= maxLevel) {
                            return
                        }

                        if (keys[r] == Object.keys(data)[r]) {

                            var x = 200 / (data[keys[r]].length + 1);

                            for (let v = 0; v < data[keys[r]].length; v++) {

                                var xe = x * (v + 1);
                                var ye = y + (50 * r);

                                //console.log(r+'-'+v);

                                points[data[keys[r]][v].document] = {
                                    'dx': xe,
                                    'dy': ye
                                };

                                if (points[data[keys[r]][v].parent_document] !== undefined) {
                                    ctx.beginPath();
                                    ctx.moveTo(points[data[keys[r]][v].parent_document].dx, points[data[keys[r]][v]
                                        .parent_document].dy);
                                    ctx.lineTo(xe, ye);
                                    ctx.stroke();
                                }
                                //html+= '<option value="'+data[keys[r]][v].document+'"> '+'---'.repeat(keys[r])+' '+data[keys[r]][v].name+'</option>';
                            }
                        }
                    }
                }
            });
        </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/b41wpxslh789/public_html/gte/resources/views/pages/tree/index.blade.php ENDPATH**/ ?>