<table class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>{{ __('roles.name') }} </th>
            <th>&nbsp;</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($records as $record)
            <tr>
                <td> {{ $record->name }} </td>
                <td>
                    <a class="btn btn-info m-1" href="{{ route('roles.show', $record->id) }}">
                        {{-- <span class="fa fa-eye"></span> --}}
                        {{ __('pages.view') }}
                    </a>
                    @can('roles-edit')
                        <a class="btn btn-primary m-1" href="{{ route('roles.edit', $record->id) }}">
                            {{-- <span class="fa fa-pencil"></span> --}}
                            {{ __('pages.edit') }}
                        </a>
                    @endcan
                    @can('roles-delete')
                        <form onsubmit="return confirm('Are you sure you want to delete?')"
                            action="{{ route('roles.destroy', $record->id) }}" method="post" style="display: inline">
                            {{ csrf_field() }}
                            {{ method_field('DELETE') }}
                            <button type="submit" class="btn btn-danger m-1 c cursor-pointer">
                                {{-- <i class="text-danger fa fa-remove"></i> --}}
                                {{ __('pages.delete') }}
                            </button>

                        </form>
                    @endcan
                </td>
            </tr>
        @endforeach
    </tbody>
    <tfoot>
        <tr>
            <td colspan="3">
                {{ $records->render() }}
            </td>
        </tr>
    </tfoot>
</table>
