@extends('layouts.app')
@section('breadcrumb')
    <li class="breadcrumb-item">
        users
    </li>
@endsection
@section('header')
    <h3><i class="fa fa-list"></i> Estructura </h3>
@endsection
@section('tools')
    <a class="btn btn-secondary" href="{{ route('users.create') }}">
        <span class="fa fa-plus"></span>
    </a>
@endsection

@section('content')
    <div class="container">
        <div class='card mb-4'>
            <div class="card-header">
                <div class="row">
                    <div class="col-md-3">
                    
                        <h4>{{ __('Estructura') }} </h4>
                    </div>
                    <div class="col-md-9">
                        <div class="row">
                            <div class="col-md-2">
                                Año:
                    
                                <select id="year" class="form-control">
                                    @if ($years ?? false)
                                    @foreach ($years as $item)
                                    <option value="{{$item}}">{{$item}}</option>
                                    @endforeach
                    
                                    @endif
                    
                    
                                </select>
                            </div>
                    
                            <div class="col-md-2">
                                Mes:
                                <select id="month" class="form-control">
                                    @if ($months ?? false)
                                   
                                    @foreach ($months as $item)
                                        <option value="{{$item['id']}}" >{{$item['name']}}</option>
                                    @endforeach
                    
                                    @endif
                    
                    
                                </select>
                            </div>
                    
                            <div class="col-md-2">
                                Integrante del Equipo:
                    
                            </div>
                            <div class="col-md-5">
                                <select id="users" class="itemName form-control ">
                                    @if ($users ?? false)
                                    @foreach ($users as $item)
                                    <option value="{{$item['id']}}">{{$item['name']}}</option>
                                    @endforeach
                    
                                    @endif
                    
                    
                                </select>
                            </div>
                            <div class="col-md-1">
                                <button id="gotoParent" class=" btn btn-primary">
                                    Arriba
                                </button>
                    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="text-center">
                    <canvas id="tree" ></canvas>
                </div>

            </div>
        </div>
        <h4>Comisiones
        </h4>
        <table class="table table-striped table-sm">
            <thead class="thead-dark">
                <tr>
                    <th colspan=2>Nivel</th>
                    <th>Ventas</th>
                    <th>%</th>
                    <th>Comisión</th>
                </tr>
            </thead>
            <tbody id="commissions">


            </tbody>
        </table>
        <div id="msgCommissions"></div>
        <br />
        <h4>Ventas
        </h4>
        <table class="table table-striped table-sm">
            <thead class="thead-dark">
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Nivel</th>
                    <th scope="col">CI</th>
                    <th scope="col">Nombres</th>
                    <th scope="col" class='text-right'>Ventas</th>
                </tr>
            </thead>
            <tbody id="teamSales">


            </tbody>
        </table>
        <div id="msgSales"></div>
        <br />

        <!-- Modal -->
        <div class="modal " id="detalleVentas" tabindex="-1" role="dialog" aria-labelledby="detalleVentasLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header" id="detalleTitulo">

                    </div>

                    <div class="modal-body" id="detalleContenido">

                    </div>
                    <div class="modal-footer">
                        <div style="width: 80%"><h4 class="float-left">Total: <div id="detalleTotal"></div></h4></div>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>

        {{-- {!! $records->render() !!} --}}
    @endSection

    @push('custom-scripts')
        <script type="module">
            var userDocument =@json($document);
            var uDocument =@json($document);
            var currentUser =@json($document);
            var screenWidth = window.innerWidth;
            $(document).ready(function() {

                console.log('hola')

                // const udocument = @json($document);
                const month = 11;
                const year = 2023;

                const maxLevel = 6;
                let infoTree = [];

                const levelColor = ['darkred', 'deepskyblue', 'limegreen', 'darkorange', 'teal', 'DarkOrchid'];
                const levelFont = ['23px sans-serif', '21px sans-serif', '19px sans-serif', '17px sans-serif',
                    '15px sans-serif', '12px sans-serif'
                ];
                const levelSize = [26, 24, 22, 20, 18, 16];

                tree(uDocument,document,month,year);



                function tree(udocument,document,month,year) {

                    if(!udocument){
                        return;
                    }

                    return $.ajax({
                        method: "POST",
                        async: true,
                        url: "{{ route('getTree') }}",
                        data: {
                            "_token": "{{ csrf_token() }}",
                            document: udocument,
                            month: month,
                            year: year
                        },
                        success: function(data) {


                            var canvas = document.getElementById('tree');

                            console.log(canvas.getContext);

                            if (canvas.getContext) {
                                var ctx = canvas.getContext('2d');

                                ctx.canvas.width = canvas.parentElement.clientWidth;
                                console.log(window.innerHeight);
                                console.log(window.innerWidth);
                                ctx.canvas.height = window.innerHeight;

                                var est = data.tree;
                                //drawNode(uDocument,my,320,40,ctx,160,0);
                                console.log(data.tree);
                                if(udocument === userDocument){
                                    drawUsers(est);
                                }

                                //var x = data.tree.length;
                                var keys = [];

                                for (var number in est) {
                                    keys.push(number);
                                }
                                //var x = data.tree.length;
                                var x = keys.length;

                                if (undefined == data.tree[x - 1]) {
                                    var nivel = data.tree[x - 2][0].level;
                                } else {
                                    var nivel = data.tree[x - 1][0].level;
                                }

                                //var nivel = data.tree[x-1][0].level;

                                // drawOwnSales(est[0][0].name,data.salesPerMonth.suma,data.salesReport.total,data.salesTReport.total,nivel);

                                // if(data.leadership){
                                //     drawLeadership(data.leadership);
                                // }

                                clearCanvas(ctx);
                                drawLines(est, ctx);
                                drawTree(est, ctx);
                                commissions(data.commissions);
                                sales(data.salesByTeam);
                            }
                        }
                    })
                }

                function clearCanvas(ctx) {
                    console.log('clear');
                    var canvas = document.getElementById('tree');
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                }

                function drawTree(data, ctx) {
                    console.log('drawTree');
                    //var ctx = canvas.getContext('2d');

                    infoTree = [];
                    var points = [];
                    var y = 40;

                    var keys = [];

                    for (var number in data) {
                        keys.push(number);
                    }

                    for (let r = 0; r < keys.length; r++) {

                        var x = ctx.canvas.width / (data[keys[r]].length + 1);

                        if (keys[r] >= maxLevel) {
                            return
                        }

                        if (keys[r] == Object.keys(data)[r]) {

                            for (let v = 0; v < data[keys[r]].length; v++) {
                                var xe = x * (v + 1);
                                var ye = y + (50 * r);
                                points[data[keys[r]][v].document] = {
                                    'dx': xe,
                                    'dy': ye
                                };

                                if (points[data[keys[r]][v].parent_document] !== undefined) {

                                }

                                var circle = new Path2D();
                                var nombres = data[keys[r]][v].name.split(' ');
                                var iniciales = '';

                                if (nombres[1]) {
                                    iniciales = nombres[0].substring(0, 1) + nombres[1].substring(0, 1);
                                } else {
                                    iniciales = nombres[0].substring(0, 1);
                                }

                                ctx.fillStyle = levelColor[keys[r]];
                                circle.arc(xe, ye, levelSize[keys[r]], 0, 2 * Math.PI);
                                // guardo en los paths
                                //pathsDocuments.push(e.document);


                                infoTree.push({
                                    document: data[keys[r]][v].document,
                                    name: data[keys[r]][v].name,
                                    path: circle,
                                    parent_document: data[keys[r]][v].parent_document
                                });

                                ctx.fill(circle);
                                ctx.font = levelFont[keys[r]];;
                                ctx.fillStyle = "white";
                                ctx.textAlign = "center";
                                //l1
                                ctx.fillText(iniciales, xe, ye + (levelSize[keys[r]] / 3));
                            }
                        }
                    }
                }

                function drawLines(data, ctx) {
                    console.log('drawLines');
                    //var ctx = canvas.getContext('2d');
                    var points = [];
                    var y = 40;

                    var keys = [];

                    for (var number in data) {
                        keys.push(number);
                    }
                    var html = '';

                    for (let r = 0; r < keys.length; r++) {

                        if (keys[r] >= maxLevel) {
                            return
                        }

                        if (keys[r] == Object.keys(data)[r]) {

                            var x = ctx.canvas.width / (data[keys[r]].length + 1);


                            for (let v = 0; v < data[keys[r]].length; v++) {

                                var xe = x * (v + 1);
                                var ye = y + (50 * r);

                                //console.log(r+'-'+v);

                                points[data[keys[r]][v].document] = {
                                    'dx': xe,
                                    'dy': ye
                                };

                                if (points[data[keys[r]][v].parent_document] !== undefined) {
                                    ctx.beginPath();
                                    ctx.moveTo(points[data[keys[r]][v].parent_document].dx, points[data[keys[r]][v]
                                        .parent_document].dy);
                                    ctx.lineTo(xe, ye);
                                    ctx.stroke();
                                }
                                //html+= '<option value="'+data[keys[r]][v].document+'"> '+'---'.repeat(keys[r])+' '+data[keys[r]][v].name+'</option>';
                            }
                        }
                    }
                }

                function commissions(commissions) {
                    console.log(commissions);
                    var html = '';

                    // html += '<tr>';
                    // html += '<th colspan=2>Nivel</th>';
                    // html += '<th>Ventas</th>';
                    // html += '<th>%</th>';
                    // html += '<th>Comisión</th>';
                    // html += '</tr>';

                    for (let i = 0; i < commissions.commissions.length; i++) {
                        html += '<tr>';
                        html += '<th colspan=2>' + commissions.commissions[i].level + '</th>';
                        html += '<th>$ ' + formatNumber(commissions.commissions[i].sales, 2, ',', '.') + '</th>';
                        html += '<th></th>';
                        html += '<th>$ ' + formatNumber(commissions.commissions[i].commission, 2, ',', '.') + '</th>';
                        html += '</tr>';
                        for (let j = 0; j < commissions.commissions[i].groups.length; j++) {

                            if (commissions.commissions[i].groups[j].sales == 0) {
                                continue;
                            }
                            html += '<tr>';
                            html += '<td></td>';
                            html += '<td>' + commissions.commissions[i].groups[j].name + '</th>';
                            html += '<td>$ ' + formatNumber(commissions.commissions[i].groups[j].sales, 2, ',', '.') +
                                '</th>';

                            html += '<td>' + (commissions.commissions[i].groups[j].percent * 100).toFixed() + '%</th>';
                            html += '<td>$ ' + formatNumber(commissions.commissions[i].groups[j].commission, 2, ',',
                                '.') + '</th>';
                            html += '</tr>';
                        }
                    }
                    // add total
                    html += '<tr>';
                    html += '<th colspan=2>Total Comisiones</th>';
                    html += '<th>$ ' + formatNumber(commissions.totalSales, 2, ',', '.') + '</th>';
                    html += '<th></th>';
                    html += '<th>$ ' + formatNumber(commissions.totalCommission, 2, ',', '.') + '</th>';
                    html += '</tr>';


                    $('#commissions').html(html);
                };

                function sales(data) {

                    var teamSales = data;
                    var str = '';
                    var salesTeam_changed_total = 0;

                    teamSales.sales.forEach((v, i, s) => {
                        //var key = Object.keys(v)[0];
                        //var val = Object.values(v)[0]
                        //console.log(v);
                        var salesTeam_changed = formatNumber(v.sales, 2, ',', '.');
                        salesTeam_changed_total = formatNumber(teamSales.total, 2, ',', '.');

                        str += "<tr>";
                        str += "<td  scope='row'>" + (i + 1) + "</td >";
                        str += "<td  scope='row'>" + 'N' + v.level + "</td >";
                        str += "<td  scope='row'>" + v.document + "</td >";
                        str +=
                            "<td  scope='row'> <span  class='detalleTVentas' data-bs-toggle='modal' data-bs-target='#detalleVentas' data-document='" +
                            v.document + "' data-name='" + v.name + "'>" + v.name + "</span></td >";
                        // str +="<th scope='row'>"+v.last_name+"</th>";

                        str += "<td scope='row' class='float-right'>$ " + salesTeam_changed + "</td>";

                        str += "</tr>";
                        i++;
                    });
                    str += "<tr>";
                    str += "<th colspan='4'><div class='float-right'>Total Ventas</div></th>";
                    str += "<th scope='row' class='float-right'>$ " + salesTeam_changed_total + "</th>";
                    str += "</tr>";

                    $('#teamSales').html(str);

                    $('.detalleTVentas').on("click", function() {
                        // $(this).val() will work here
                        //console.log('click');
                        var month = $('#month').val();
                        var year = $('#year').val();
                        //alert('selecciono el mes '+month);
                        var document = $(this).data("document");
                        var name = $(this).data("name");
                        $('#detalleContenido').html('');
                        $('#detalleTotal').html('');

                        $('#detalleTitulo').html('<h5 class="modal-title" id="exampleModalLabel">Ventas de ' +
                            name + '</h5>');


                        obtenerDetalleVentas(document, month, year);
                    });
                }

                function obtenerDetalleVentas(udocument, month, year) {
                    const fecha = new Date();
                    const hoy = fecha.getDate();
                    const mesActual = fecha.getMonth();

                    if (month == '' || month == null) {
                        month = mesActual;
                    }
                    /*console.log(month);
                    console.log("-");
                    console.log(mesActual);*/
                    //var year = 2020;

                    return $.ajax({


                        method: "POST",
                        async: true,
                        url: 'salesDetails',
                        data: {
                            "_token": "{{ csrf_token() }}",
                            document: udocument,
                            month: month,
                            year: year
                        },
                        success: function(data) {

                            //console.log(data);
                            salesDetails(data);

                        }
                    })
                }

                function salesDetails(data){
                    var data_total = formatNumber(data.total,2,',','.');
                    $('#detalleTotal').html( data_total);

                    //var ctx = canvas.getContext('2d');
                    var html='';
                    html +="<table class='table table-striped table-sm'>";
                    //  html +="<th><h5>$"+ Number(salesTeam).toFixed(2)+"</h5></th>"
                    html +="<thead class='thead-dark'>";
                    html +="<tr>";
                    html +="<th> CLIENTE ID</th>";
                    // html +="<th> NOMBRES</th>";
                    // html +="<th> AGENCIA</th>";
                    html +="<th># DOCUMENTO</th>";
                    html +="<th>MONTO</th>";
                    html +="</tr>";
                    html +="</thead>";
                    html +="<tbody>";

                    var sales = data.sales;
                    sales.forEach((l,j)=>{
                        html +="<tr>";
                        html +="<td  scope='row'>"+ l.CLIENTE_ID+"</td >";
                        html +="<td  scope='row'>"+ l.NUMERO_DOCUMENTO+"</td >";
                        // html +="<td  scope='row'>"+ l.AGENCIA+"</td >";
                        // html +="<td  scope='row'>"+ l.NUMERO_FACTURA+"</td >";
                        html +="<td  scope='row'  class='text-right'> $"+ formatNumber(l.TOTAL,2,',','.')+"</td >";
                        html +="</tr>";
                    })
                    html +="</tbody>";
                    html +="</table>";

                    $('#detalleContenido').html(html);
                    //$('#teamSales').html(html2);
                }

                function drawUsers(data){

                    var keys = [];

                    for (var number in data) {
                    //if (data.hasOwnProperty(number)) {
                        keys.push(number);
                    //}
                    }

                    var html='';

                    for(let r=0; r<keys.length; r++){

                        if(keys[r] == Object.keys(data)[r]){
                            for(let v=0; v<data[keys[r]].length; v++){
                                html+= '<option value="'+data[keys[r]][v].document+'"> '+'---'.repeat(keys[r])+' '+data[keys[r]][v].name+'</option>';
                            }
                        }
                    }

                    $('#users').html(html);
                }

                $('#users').change(function() {
                    console.log('hola cambia usuario');
                    var month = $('#month').val();
                    var year = $('#year').val();

                    tree($(this).val(),document,month,year);
                    currentUser = $(this).val();
                });
            });

            function formatNumber(number, decimals, dec_point, thousands_point) {

                if (!isFinite(number)) {
                    throw new TypeError("number is not valid");
                }

                if (number == null) {
                    number = 0.00;
                }

                if (!decimals) {
                    var len = number.toString().split('.').length;
                    decimals = len > 1 ? len : 0;
                }

                if (!dec_point) {
                    dec_point = '.';
                }

                if (!thousands_point) {
                    thousands_point = ',';
                }

                number = parseFloat(number).toFixed(decimals);
                number = number.replace(".", dec_point);

                var splitNum = number.split(dec_point);
                splitNum[0] = splitNum[0].replace(/\B(?=(\d{3})+(?!\d))/g, thousands_point);
                number = splitNum.join(dec_point);

                return number;
            }
            
        </script>
    @endpush
