<form action="{{ isset($route) ? $route : route('clients.search') }}" method="POST">
    {{ csrf_field() }}
<fieldset class="row">
    {{-- // show session flash message --}}


        <input type="hidden" name="_method" value="{{ isset($method) ? $method : 'POST' }}" />
        @if (session('app_error'))
        <div class="container">
        <div class="alert alert-warning">
            {{ session('app_error') }}
        </div>
        </div>
        @endif
        <div class="form-group  col-md-4">
            <label for="search">{{ __('clients.search') }}</label>
            <input type="text" class="form-control {{ $errors->has('search') ? ' is-invalid' : '' }}" name="search"
                id="search" placeholder="Cédula / Nombre" maxlength="15">
            @if ($errors->has('search'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('search') }}</strong>
                </div>
            @endif
        </div>

        <div class="form-group col-md-2">
            <button type="submit" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal" > Buscar
            </button>
        </div>
        <div class="col-sm-4">
            <a href="{{ route('clients.create',['goOrder'=>true]) }}"
        class="btn btn-success">+ {{ __('pages.add') }}</a>
        </div>
    </fieldset>
    <fieldset>
        <table class="w-100">
            <thead>
                <tr>
                    <th>Identificacion</th>
                    <th>Razon Social</th>
                    <th>-</th>
                </tr>
            </thead>
            <tbody>
                @if (isset($clients))
                    @foreach ($clients as $client)
                        <tr>
                            <td>{{ $client->NIT ?? $client->CardCode  }}</td>
                            <td>{{ $client->RAZON_SOCIAL ?? $client->CardName }}</td>
                            <td>
                                <a href="{{route('orders.create_history',['client_code'=>$client->CLIENTE_ID?$client->CLIENTE_ID:$client->CardCode,'client_name'=>$client->RAZON_SOCIAL?$client->RAZON_SOCIAL:$client->CardName,"new_client"=>$new_client])}}" class="btn btn-sm btn-info">Seleccionar</a>

                            </td>
                        </tr>
                    @endforeach
                @endif
        </table>
    </fieldset>
</form>
