<form action="{{ isset($route) ? $route : route('orders.updatemanage') }}" method="POST" id="order_manage_form">
    {{ csrf_field() }}
    <input type="hidden" name="_method" value="{{ isset($method) ? $method : 'POST' }}" />
    <div class="row">
        <input type="hidden" name="id" value="{{ old('id', $record->id) }}" />

        <div class="form-group col-12">
            <label for="DocDate">{{__("orders.DocDate")}}</label>
            <div class="input-group">
                <input type="date" class="form-control {{ $errors->has('DocDate') ? ' is-invalid' : '' }}"
                    name="DocDate" id="DocDate" value="{{ old('DocDate', $record->DocDate) }}" placeholder="" disabled readonly>
                <div class="input-group-addon">
                    <label for="DocDate" class="fa fa-calendar">
                    </label>
                </div>
            </div>
            @if ($errors->has('DocDate'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('DocDate') }}</strong>
                </div>
            @endif
        </div>

        <div class="form-group col-12">
            <label for="amount">{{__('orders.amount')}}</label>
            <input type="text" class="form-control {{ $errors->has('amount') ? ' is-invalid' : '' }}"
                name="amount" id="amount" value="{{ old('amount', $record->amount) }}" placeholder=""
                maxlength="254" disabled readonly>
            @if ($errors->has('amount'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('amount') }}</strong>
                </div>
            @endif
        </div>
        
        <div class="form-group col-12">
            <label for="expected_amount">{{__('orders.expected_amount')}}</label>
            <input type="text" class="form-control {{ $errors->has('expected_amount') ? ' is-invalid' : '' }}"
                name="expected_amount" id="expected_amount" value="{{ old('expected_amount', $record->expected_amount) }}" placeholder=""
                maxlength="254">
            @if ($errors->has('expected_amount'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('expected_amount') }}</strong>
                </div>
            @endif
        </div>

        <div class="form-group col-6">
            <label for="status">{{__('orders.status')}}</label>
            <select class="form-control {{ $errors->has('status') ? ' is-invalid' : '' }} select2" name="status"
                id="status" value="{{ old('status', $record->status) }}" placeholder="" maxlength="15">
                <option value="Cerrado sin facturar" {{ $record->status == "Cerrado sin facturar"? "selected":"" }}>Cerrado sin facturar</option>
                <option value="Cotizado" {{ $record->status == "Cotizado"? "selected":"" }}>Cotizado</option>
                <option value="En negociacion" {{ $record->status == "En negociacion"? "selected":"" }}>En negociación</option>
                <option value="Facturado" {{ $record->status == "Facturado"? "selected":"" }}>Facturado</option>
                

            </select>
            @if ($errors->has('status'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('status') }}</strong>
                </div>
            @endif
        </div>
        
        <div class="form-group col-6">
            <label for="progress">{{__('orders.progress')}}</label>
            <input type="text" class="form-control {{ $errors->has('progress') ? ' is-invalid' : '' }}"
                name="progress" id="progress" value="{{ old('progress', $record->progress) }}" placeholder=""
                maxlength="254" disabled readonly>
            @if ($errors->has('progress'))
                <div class="invalid-feedback">
                    <strong>{{ $errors->first('progress') }}</strong>
                </div>
            @endif
        </div>
        


        <div class="form-group text-right mt-4 ">
            <input type="submit" class="btn btn-primary w-100" value="{{__('pages.save')}}" />

        </div>
    </div>
</form>
@push('custom-scripts')
    <script type="module">
        $(document).ready(function() {

            // let order_details = [];


            $('.select2').select2({
                theme: "classic"
            });
        });
    </script>
@endpush
