<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

     /*
     Campo	Descripción	Tipo
ItemCode	Código del Artículo	Varchar (50)
Quantity	Cantidad	Numeric
UnitPrice	Precio de Venta	Numeric
DiscountPercent	Porcentaje de Descuento	Numeric
WarehouseCode	Almacén	Varc h ar (8)
TaxCode	Indicador de impuesto	Varchar (8)
     */
    public function up(): void
    {
        Schema::create('order_detail', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_header_id')->nullable()->unsigned();
            $table->string('ItemCode',50)->nullable();
            $table->decimal('Quantity',18,6)->nullable();
            $table->decimal('UnitPrice',18,6)->nullable();
            $table->decimal('DiscountPercent',18,6)->nullable();
            $table->string('WarehouseCode',8)->nullable();
            $table->string('TaxCode',8)->nullable();
            $table->timestamps();
            $table->foreign('order_header_id')->references('id')->on('order_header')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_detail');
    }
};
