<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            //let add new column after bio data
            //the data type is json, so that it can save list file
            $table->string('CardCode',15)->nullable()->before('remember_token');
            $table->string('CardName',100)->nullable()->before('remember_token');
            $table->char('CardType',1)->nullable()->before('remember_token');
            $table->string('U_HT_TIPO_ID',2)->nullable()->before('remember_token');
            $table->smallInteger('GroupCode')->nullable()->before('remember_token');
            $table->char('CmpPrivate',1)->nullable()->before('remember_token');
            $table->string('Phone1',20)->nullable()->before('remember_token');
            $table->string('Cellular',50)->nullable()->before('remember_token');
            $table->string('E_Mail',100)->nullable()->before('remember_token');
            $table->smallInteger('GroupNum')->nullable()->before('remember_token');
            $table->string('LicTradNum',32)->nullable()->before('remember_token');
            $table->string('Notes',100)->nullable()->before('remember_token');
            $table->string('Address',100)->nullable()->before('remember_token');
            $table->string('City',100)->nullable()->before('remember_token');
            $table->string('Country',3)->nullable()->before('remember_token');
            $table->string('MailCity',100)->nullable()->before('remember_token');
            $table->string('MailCountr',3)->nullable()->before('remember_token');
            $table->string('MailAddres',100)->nullable()->before('remember_token');
            $table->integer('ListNum')->nullable()->before('remember_token');
            $table->text('Free_Text',16)->nullable()->before('remember_token');
            $table->integer('SlpCode')->nullable()->before('remember_token');
            $table->string('U_HBT_TIPO_ID',2)->nullable()->before('remember_token');
            $table->string('U_HBT_TIPPRO',2)->nullable()->before('remember_token');
            $table->string('U_HBT_ATRESI',2)->nullable()->before('remember_token');
            $table->string('U_HBT_TIPCONT',2)->nullable()->before('remember_token');
            $table->string('U_HBT_PARTREL',2)->nullable()->before('remember_token');
            $table->string('U_HBT_ENT_RET',2)->nullable()->before('remember_token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
};
