<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
/**
   @property bigint $promo_id promo id
@property varchar $filename filename
@property timestamp $created_at created at
@property timestamp $updated_at updated at
@property Promo $promo belongsTo
   
 */
class PromoDetail extends Model 
{
    
    /**
    * Database table name
    */
    protected $table = 'promo_details';

    /**
    * Mass assignable columns
    */
    protected $fillable=['promo_id',
'filename'];

    /**
    * Date time columns.
    */
    protected $dates=[];

    /**
    * promo
    *
    * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
    */
    public function promo()
    {
        return $this->belongsTo(Promo::class,'promo_id');
    }




}