<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
/**
   @property varchar $name name
@property int $status status
@property timestamp $created_at created at
@property timestamp $updated_at updated at
@property \Illuminate\Database\Eloquent\Collection $promoDetail hasMany
   
 */
class Promo extends Model 
{
    
    /**
    * Database table name
    */
    protected $table = 'promos';

    /**
    * Mass assignable columns
    */
    protected $fillable=['name'];

    /**
    * Date time columns.
    */
    protected $dates=[];

    /**
    * promoDetails
    *
    * @return \Illuminate\Database\Eloquent\Relations\HasMany
    */
    public function promoDetails()
    {
        return $this->hasMany(PromoDetail::class,'promo_id');
    }



}