<?php
namespace App\Models;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
/**
   @property int $Series Series
@property date $DocDate DocDate
@property varchar $CardCode CardCode
@property varchar $CardName CardName
@property varchar $GroupName GroupName
@property varchar $WarehouseCode WarehouseCode
@property varchar $WarehouseName WarehouseName
@property varchar $ProductName ProductName
@property varchar $ProductDescription ProductDescription
@property double $PriceAfterDiscount PriceAfterDiscount
@property int $Quantity Quantity
@property double $Discount Discount
@property double $Total Total
@property double $Price Price
@property int $Type Type
@property int $InternalNumber InternalNumber
@property decimal $DiscountPercent DiscountPercent
@property varchar $DocType DocType
@property int $BPL_IDAssignedToInvoice BPL IDAssignedToInvoice
@property int $SalesPersonCode SalesPersonCode
@property varchar $SalesPersonName SalesPersonName
@property timestamp $created_at created at
@property timestamp $updated_at updated at
   
 */
class OrderHistory extends Model 
{
    
    /**
    * Database table name
    */
    protected $table = 'order_history';

    /**
    * Mass assignable columns
    */
    protected $fillable=['Series',
'DocDate',
'CardCode',
'CardName',
'GroupName',
'WarehouseCode',
'WarehouseName',
'ProductName',
'ProductDescription',
'PriceAfterDiscount',
'Quantity',
'Discount',
'Total',
'Price',
'Type',
'InternalNumber',
'DiscountPercent',
'DocType',
'BPL_IDAssignedToInvoice',
'SalesPersonCode',
'SalesPersonName'];

    /**
    * Date time columns.
    */
    protected $dates=['DocDate'];
    
    public function getLastTransacction()
    {
        return OrderHistory::where('CardCode', $this->CardCode)->orderBy('DocDate', 'DESC')->first();
    }

    // public function getLastType()
    // {
    //     return $this->getLastTransacction()->Type;
    // }
    
    // public function getLastTransacctionDate()
    // {
    //     return $this->getLastTransacction()->DocDate;
    // }

    public function getDaysLastTransacction()
    {
        $date = Carbon::parse($this->getLastTransacction()->DocDate);
        $now = Carbon::now();

        $diff = $date->diffInDays($now);

        return $diff;
    }

    public function getManageStatus()
    {
        // $today = date('Y-m-d');
        // $followup_date = $this->getFollowupDateAttribute();

        $last_transaction_date = Carbon::parse($this->getLastTransacction()->DocDate);
        $last_year = Carbon::now()->subYear();
        $last_six_months = Carbon::now()->subMonths(6);

        // return $followup_date;

        
        if ($last_transaction_date) {
            if ($last_year->gt($last_transaction_date)) {
                return '<span class="badge bg-danger">Sin Recompra</span>';
            } else if ($last_transaction_date->between($last_year, $last_six_months)) {
                return '<span class="badge bg-warning">Considerables</span>';;
            } else {
                return '<span class="badge bg-success">Reciente</span>';;
            }
        } else {
            return '-';
        }
    }


}