<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
/**
   @property timestamp $created_at created at
@property timestamp $updated_at updated at
@property bigint $order_id order id
@property bigint $user_id user id
@property varchar $activity activity
@property varchar $comments comments
@property date $followup_date followup date
   
 */
class OrderActivity extends Model 
{
    
    /**
    * Database table name
    */
    protected $table = 'order_activities';

    /**
    * Mass assignable columns
    */
    protected $fillable=['followup_date',
'order_id',
'user_id',
'activity',
'comments',
'followup_date'];

    /**
    * Date time columns.
    */
    protected $dates=['followup_date'];


    public function order()
    {
        return $this->belongsTo(OrderHeader::class,'order_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }




}