<?php

namespace App\Http\Requests\Users;

use Illuminate\Foundation\Http\FormRequest;

class Store extends FormRequest 
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize() 
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules() 
    {
        return [
			'name' => 'required|max:255',
			'email' => 'required|unique:users,email|max:255',
			// 'email_verified_at' => 'nullable|date',
			'document' => 'required|unique:users,document|max:13',
			'parent_document' => 'required|max:13',
			'type' => 'nullable|max:100',
			'address' => 'nullable|max:255',
			'movile' => 'nullable|max:50',
			'phone' => 'nullable|max:50',
			// 'status' => 'required|max:2',
			'genre' => 'nullable|max:2',
			// 'avatar' => 'required|max:255',
			'birthday' => 'nullable|date',
			'civil_status' => 'nullable|max:100',
			'country' => 'nullable|max:100',
			'province' => 'nullable|max:20',
            'canton' => 'nullable|max:20',
			'parish' => 'nullable|max:20',
			'bank' => 'nullable|max:100',
			'account_number' => 'nullable|max:100',
			'account_type' => 'nullable|max:50',
			// 'profile' => 'required|numeric',
			// 'leadership' => 'nullable|max:100',
			// 'entry_date' => 'nullable|date',
        ];
    }

    /**
    * Get the error messages for the defined validation rules.
    *
    * @return array
    */
    public function messages()
    {
        return [
     
        ];
    }

}
