<?php

namespace App\Http\Requests\OrderHeader;

use Illuminate\Foundation\Http\FormRequest;

class Store extends FormRequest 
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize() 
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules() 
    {
        return [
			'Series' => 'nullable|numeric',
			'DocDate' => 'nullable|date',
			'TaxDate' => 'nullable|date',
			'DocDueDate' => 'nullable|date',
			'CardCode' => 'nullable|max:15',
			'SalesPersonCode' => 'nullable|numeric',
			'Comments' => 'nullable|max:254',
			'DiscountPercent' => 'nullable|numeric',
			'DocType' => 'nullable|max:1',
			'BPL_IDAssignedToInvoice' => 'nullable|numeric',
        ];
    }

    /**
    * Get the error messages for the defined validation rules.
    *
    * @return array
    */
    public function messages()
    {
        return [
     
        ];
    }

}
