<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\ConfigCommission;
use App\Models\GteVentasReale;
use App\Models\OrderHeader;
use App\Models\User;

class TreeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();

        $explode = explode(' ', $user->name);
        $nombre = $explode[0];
        $apellido = isset($explode[1]) ? $explode[1] : '';

        $years = $this->yearsAvailables($user->document);
        $months = $this->monthsAvailables($user->document);

        return view('pages.tree.index', ['document' => $user->document, 'nombre' => $nombre, 'apellido' => $apellido,'years' => $years, 'months' => $months]);
    }

    public function getTree(Request $request)
    {
        $document = $request->document;
        $month = $request->month;
        $year = $request->year;


        $allTeam = $this->treeGeneral($document);

        $commissions   = $this->commissions($allTeam['tree'], $month, $year);

        $salesByTeam = $this->salesByTeam($allTeam['tree'], $month, $year);


        return $result = ['tree' => $allTeam['treeN'], 'commissions' => $commissions, 'salesByTeam' => $salesByTeam];
    }

    public function treeGeneral($document)
    {

        $arbol = [];
        $arbolN = [[]];
        $i = 0;
        $ids = $document;

        while ($ids) {
            if (!$ids || $ids == '') {
                break;
            }
            //agregar larestriccion por fecha de ingreso

            $arbol[$i] = $ids;
            $queryv = "SELECT document FROM users WHERE parent_document != document  AND parent_document != '' AND parent_document IN ({$ids}) ";
            $sthv = DB::getPdo()->prepare($queryv);
            $sthv->execute();
            $resultadosv = $sthv->fetchAll(\PDO::FETCH_ASSOC);
            //var_dump($queryv);

            $query = "SELECT u.document,u.name,u.parent_document,{$i} as level FROM users u LEFT JOIN users pu ON pu.document = u.parent_document WHERE u.status = 'A'  AND u.document IN ({$ids}) ORDER BY  CONVERT(u.parent_document,UNSIGNED),CONVERT(u.document,UNSIGNED)";

            $sth = DB::getPdo()->prepare($query);
            $sth->execute();
            $resultados = $sth->fetchAll(\PDO::FETCH_ASSOC);
            $idsv = '';

            foreach ($resultadosv as $row) {
                $idsv .= "," . $row['document'];
            }

            foreach ($resultados as $row) {
                $arbolN[$i][] = $row;
            }

            $ids = ltrim($idsv, ',');
            $i++;
        }

        $team = [];
        foreach ($arbol as $a) {
            $cn = explode(',', $a);
            foreach ($cn as $c) {
                $team[] = $c;
            }
        }

        $years = $this->yearsAvailables($document);
        $months = $this->monthsAvailables($document);

        return ['tree' => $arbol, 'treeN' => $arbolN, 'all' => $team, 'years' => $years, 'months' => $months];
    }

    public function tree($document)
    {

        $limit = 6;

        $arbol = [];
        $i = 0;
        $ids = $document;

        while ($ids) {
            if (!$ids || $i >= $limit) {
                break;
            }

            //agregar larestriccion por fecha de ingreso

            $arbol[$i] = $ids;
            $queryv = "SELECT document FROM users WHERE status = 'A'   AND parent_document != document  AND parent_document != '' AND parent_document IN ({$ids}) ";
            $sthv = DB::getPdo()->prepare($queryv);
            $sthv->execute();
            $resultadosv = $sthv->fetchAll(\PDO::FETCH_ASSOC);

            $idsv = '';

            foreach ($resultadosv as $row) {
                $idsv .= ',' . $row['document'];
            }

            $ids = ltrim($idsv, ',');

            $i++;
        }

        $team = [];
        foreach ($arbol as $a) {
            $cn = explode(',', $a);
            foreach ($cn as $c) {
                $team[] = $c;
            }
        }
        //print_r(json_encode($arbol));
        return ['tree' => $arbol, 'all' => $team];
    }


    public function commissions($tree, $month, $year)
    {
        $month = 4;
        $year = 2024;
       

        $config_commissions = ConfigCommission::all();

        $i = 0;

        $commissions = [];

        $productGroups = [
                ["name" => "PR - Llantas autos y camionetas", "id"=>"01"],
                ["name" => "Llantas Camión", "id"=>"02"],
                ["name" => "Baterias", "id"=>"03"],
                ["name" => "Lubricantes", "id"=>"04"],
                ["name" => "Servicios", "id"=>"05"]
            ];

        foreach ($tree as $a) {

            $group = explode(',', $a);

            // Orders

            $orders = OrderHeader::join('users', 'users.id', '=', 'order_header.user_id')
                ->select('order_header.DocNum')
                ->whereNotNull('order_header.DocNum')
                ->whereIn('users.document', $group)
                ->whereMonth('order_header.DocDate', $month)
                ->whereYear('order_header.DocDate', $year)
                ->pluck("DocNum");


            $productRows = GteVentasReale::join('gte_productos', 'gte_productos.PRODUCTO_ID', '=', 'gte_ventas_reales.PRODUCTO_ID')
                ->join('gte_productos_lineas', 'gte_productos_lineas.LINEA_ID', '=', 'gte_productos.LINEA_ID')
                ->select('gte_ventas_reales.VALOR_TOTAL', 'gte_productos_lineas.GRUPO_ID')
                ->whereIn('gte_ventas_reales.NUMERO_DOCUMENTO', $orders)
                ->get();

            $commissionsbygroup = [];

            for ($j = 0; $j < count($productGroups); $j++) {
                $value = 0;
                foreach ($productRows as $productRow) {
                    if ($productRow->GRUPO_ID == $productGroups[$j]['id']) {
                        $value += $productRow->VALOR_TOTAL;
                    }
                }
                $commissionsbygroup[] = [
                    'name' => $productGroups[$j]['name'],
                    'sales' => round($value, 2),
                    'percent' => sprintf("%.4f", $config_commissions[$i]['g'.$j+1]),
                    'commission' => sprintf("%.4f", $value * $config_commissions[$i]['g'.$j+1])
                ];
            }

            $commissions[] =
                [
                    'level' => $config_commissions[$i]['name'],
                    'groups' => $commissionsbygroup,
                    'sales' => array_sum(array_column($commissionsbygroup, 'sales')),
                    'commission' => array_sum(array_column($commissionsbygroup, 'commission'))
                ];

            $i++;
        }

        $totalCommission = array_sum(array_column($commissions, 'commission'));
        $totalSales = array_sum(array_column($commissions, 'sales'));
        
        return ['commissions' => $commissions, 'totalCommission' => $totalCommission, 'totalSales' => $totalSales];
    }

    public function salesByTeam($team, $month, $year)
    {
        $month = 4;
        $year = 2024;

        $sales = [];

        $total = 0;

        $l = 0;
        foreach ($team as $a) {

            $group = explode(',', $a);

            //for each element of the group
            foreach ($group as $g) {
                $user = User::where('document', $g)->first();
                $orders = OrderHeader::join('users', 'users.id', '=', 'order_header.user_id')
                    ->select('order_header.DocNum')
                    ->whereNotNull('order_header.DocNum')
                    ->where('users.document', $g)
                    ->whereMonth('order_header.DocDate', $month)
                    ->whereYear('order_header.DocDate', $year)
                    ->pluck("DocNum");

                $userSales = GteVentasReale::whereIn('gte_ventas_reales.NUMERO_DOCUMENTO', $orders)
                    ->sum('VALOR_TOTAL');

                $sales[] = ['level' => $l + 1, 'document' => $g, 'name' => $user->name, 'sales' => round($userSales, 2)];

                $total += $userSales;
            }


            $l++;
        }


        return ['sales' => $sales, 'total' => $total];
    }

    public function salesDetails(Request $request)
    {

        $document = $request->document;
        // $month = $request->month;
        // $year = $request->year;

        $month = 4;
        $year = 2024;

        $orders = OrderHeader::join('users', 'users.id', '=', 'order_header.user_id')
            ->select('order_header.DocNum')
            ->whereNotNull('order_header.DocNum')
            ->where('users.document', $document)
            ->whereMonth('order_header.DocDate', $month)
            ->whereYear('order_header.DocDate', $year)
            ->pluck("DocNum");

        $sales = GteVentasReale::whereIn('gte_ventas_reales.NUMERO_DOCUMENTO', $orders)
            ->select('FECHA','CLIENTE_ID','NUMERO_DOCUMENTO', DB::raw('sum(VALOR_TOTAL) as TOTAL'))
            ->groupBy('FECHA','CLIENTE_ID','NUMERO_DOCUMENTO')
            ->get();


        $total = 0;
        foreach ($sales as $item) {
            $total += $item['TOTAL'];
        }

        return ['sales' => $sales, 'total' => sprintf("%.4f", $total)];
    }

    public function monthsAvailables($document)
    {

        $mesesN = array(
            "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio",
            "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
        );

        $team = $this->team($document);

        $c = implode(',', $team);

        $values = DB::table('users_sales')
            ->select('month')
            ->join('users', 'users.document', '=', 'users_sales.document')
            ->whereRaw('users_sales.document IN (' . $c . ')')
            ->groupBy('month')
            ->orderBy(DB::raw('ABS(year)'), 'ASC')
            ->orderBy(DB::raw('ABS(month)'), 'ASC')
            ->get();

        $months = [];

        $month = date('m');


        $checkMonth = 0;

        $checkMonthJanuary = 0;
        foreach ($values as $item) {

            $month_num = $item->month;
            $month_name = $mesesN[$month_num - 1];

            $months[] = ['name' => $month_name, 'id' => $month_num];

            $month_num == $month ? $checkMonth = 1 : '';
        }


        if ($checkMonth === 0) {
            $month_num = $month * 1;
            $month_name = $mesesN[$month_num - 1];
            $months[] = ['name' => $month_name, 'id' => $month_num];
        }

        if ($checkMonthJanuary === 0) {
            $month_num = $month * 1;
            $month_name = $mesesN[$month_num - 1];
            $months[] = ['name' => $month_name, 'id' => $month_num];
        }


        $lastMont = \Carbon\Carbon::now()->subMonths(1);

        $fecha = json_encode($lastMont);
        $fechaComoEntero = strtotime(json_decode($fecha));
        //print_r($fechaComoEntero);
        $mesI = 0;
        $mesF = 0;

        $mesI = date("m", $fechaComoEntero);

        if ($mesI != 10) {
            $month_num = $mesI * 1;
            $mesF = str_replace("0", "", $mesI);
            $month_name = $mesesN[$month_num - 1];
            $months[] = ['name' => $month_name, 'id' => $month_num];
            //echo $mesF;
        } else {
            $month_num = $mesI * 1;
            $month_name = $mesesN[$month_num - 1];
            $months[] = ['name' => $month_name, 'id' => $month_num];
            //echo $mesI;    
        }
        $months = array_unique($months, SORT_REGULAR);
        return $months;
    }

    public function yearsAvailables($document)
    {
        $team = $this->team($document);
        $c = implode(',', $team);
        $values = DB::table('users_sales')
            ->select('year')
            ->join('users', 'users.document', '=', 'users_sales.document')
            ->whereRaw('users_sales.document IN (' . $c . ')')
            ->groupBy('year')
            ->orderBy(DB::raw('ABS(year)'), 'ASC')
            ->get();
        $years = [];

        $year = date('Y');

        $checkYear = 0;
        foreach ($values as $item) {
            $year == $item->year ? $checkYear = 1 : '';
            $years[] = $item->year;
        }

        !$checkYear ? $years[] = $year : '';



        return $years;
    }

    public function team($document)
    {
        $team = [];
        $arbol = $this->tree($document)['all'];
        foreach ($arbol as $a) {
            $cn = explode(',', $a);
            foreach ($cn as $c) {
                $team[] = $c;
            }
        }
        //print_r(json_encode($team));
        return $team;
    }
    
}
