<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\GteProductosLinea;
use App\Http\Requests\GteProductosLineas\Index;
use App\Http\Requests\GteProductosLineas\Show;
use App\Http\Requests\GteProductosLineas\Create;
use App\Http\Requests\GteProductosLineas\Store;
use App\Http\Requests\GteProductosLineas\Edit;
use App\Http\Requests\GteProductosLineas\Update;
use App\Http\Requests\GteProductosLineas\Destroy;


/**
 * Description of GteProductosLineaController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class GteProductosLineaController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        return view('pages.gte_productos_lineas.index', ['records' => GteProductosLinea::paginate(10)]);
    }    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  GteProductosLinea  $gteproductoslinea
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, GteProductosLinea $gteproductoslinea)
    {
        return view('pages.gte_productos_lineas.show', [
                'record' =>$gteproductoslinea,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {

        return view('pages.gte_productos_lineas.create', [
            'model' => new GteProductosLinea,

        ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new GteProductosLinea;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'GteProductosLinea saved successfully');
            return redirect()->route('gte_productos_lineas.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving GteProductosLinea');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  GteProductosLinea  $gteproductoslinea
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, GteProductosLinea $gteproductoslinea)
    {

        return view('pages.gte_productos_lineas.edit', [
            'model' => $gteproductoslinea,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  GteProductosLinea  $gteproductoslinea
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,GteProductosLinea $gteproductoslinea)
    {
        $gteproductoslinea->fill($request->all());

        if ($gteproductoslinea->save()) {
            
            session()->flash('app_message', 'GteProductosLinea successfully updated');
            return redirect()->route('gte_productos_lineas.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating GteProductosLinea');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  GteProductosLinea  $gteproductoslinea
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, GteProductosLinea $gteproductoslinea)
    {
        if ($gteproductoslinea->delete()) {
                session()->flash('app_message', 'GteProductosLinea successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting GteProductosLinea');
            }

        return redirect()->back();
    }
}
