<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ConfigCommission;
use App\Http\Requests\ConfigCommissions\Index;
use App\Http\Requests\ConfigCommissions\Show;
use App\Http\Requests\ConfigCommissions\Create;
use App\Http\Requests\ConfigCommissions\Store;
use App\Http\Requests\ConfigCommissions\Edit;
use App\Http\Requests\ConfigCommissions\Update;
use App\Http\Requests\ConfigCommissions\Destroy;


/**
 * Description of ConfigCommissionController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class ConfigCommissionController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        return view('pages.config_commissions.index', ['records' => ConfigCommission::paginate(10)]);
    }    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  ConfigCommission  $config_commission
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, ConfigCommission $config_commission)
    {
        return view('pages.config_commissions.show', [
                'record' =>$config_commission,
        ]);

    }    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {

        return view('pages.config_commissions.create', [
            'model' => new ConfigCommission,

        ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new ConfigCommission;
        $model->fill($request->all());

        if ($model->save()) {
            
            session()->flash('app_message', 'ConfigCommission saved successfully');
            return redirect()->route('config_commissions.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving ConfigCommission');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  ConfigCommission  $config_commission
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, ConfigCommission $config_commission)
    {

        return view('pages.config_commissions.edit', [
            'model' => $config_commission,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  ConfigCommission  $config_commission
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,ConfigCommission $config_commission)
    {
        $config_commission->fill($request->all());

        if ($config_commission->save()) {
            
            session()->flash('app_message', 'ConfigCommission successfully updated');
            return redirect()->route('config_commissions.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating ConfigCommission');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  ConfigCommission  $config_commission
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, ConfigCommission $config_commission)
    {
        if ($config_commission->delete()) {
                session()->flash('app_message', 'ConfigCommission successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting ConfigCommission');
            }

        return redirect()->back();
    }
}
