<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Client;
use App\Http\Requests\Clients\Index;
use App\Http\Requests\Clients\Show;
use App\Http\Requests\Clients\Search;
use App\Http\Requests\Clients\Create;
use App\Http\Requests\Clients\Store;
use App\Http\Requests\Clients\Edit;
use App\Http\Requests\Clients\Update;
use App\Http\Requests\Clients\Destroy;
use App\Models\GteCliente;

/**
 * Description of ClientController
 *
 * @author Tuhin Bepari <digitaldreams40@gmail.com>
 */

class ClientController extends Controller
{
       /**
     * Display a listing of the resource.
     *
     * @param  Index  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Index $request)
    {
        $search = $request->input('search');

        $clients = Client::where('CardCode', 'LIKE', "%{$search}%")
        ->orWhere('CardName', 'LIKE', "%{$search}%")
        ->orWhere('E_Mail', 'LIKE', "%{$search}%")
        ->orderBy('id','ASC')->paginate(20);

        return view('pages.clients.index', ['records' => $clients]);
    }    /**
     * Display the specified resource.
     *
     * @param  Show  $request
     * @param  Client  $client
     * @return \Illuminate\Http\Response
     */
    public function show(Show $request, Client $client)
    {

        //if method is post then it's search query

        
        
        return view('pages.clients.show', [
                'record' =>$client,
        ]);

    }
    
    public function search(Search $request, Client $client)
    {

        if($request->input('search') != null){
            $new_client = false;

            $search = $request->input('search');
            $clients = GteCliente::where('CLIENTE_ID', 'LIKE', "%{$search}%")
            ->orWhere('RAZON_SOCIAL', 'LIKE', "%{$search}%")
            ->orderBy('id','ASC')->paginate(20);
            if($clients->isEmpty()){

                $clients = Client::where('CardCode', 'LIKE', "%{$search}%")
                ->orWhere('CardName', 'LIKE', "%{$search}%")
                ->orWhere('E_Mail', 'LIKE', "%{$search}%")
                ->orderBy('id','ASC')->paginate(20);
                $new_client = true;

                if($clients->isEmpty()){
                    session()->flash('app_error', 'No se encontraron resultados');
                }
                // session()->flash('app_error', 'No se encontraron resultados');
            }else{
                //clear message
                session()->forget('app_error');
            }
            // return $clients;
            return view('pages.clients.search', ['clients' => $clients, 'new_client' => $new_client]);
        }
        return view('pages.clients.search', [
                'record' =>$client,
        ]);

    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @param  Create  $request
     * @return \Illuminate\Http\Response
     */
    public function create(Create $request)
    {

        // return $request;

        return view('pages.clients.create', [
            'model' => new Client,
            'goOrder' => $request->input('goOrder'),
        ]);
    }    /**
     * Store a newly created resource in storage.
     *
     * @param  Store  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Store $request)
    {
        $model=new Client;
        $model->fill($request->all());
        $model->CardCode = 'C'.$request->input('document');
        $model->CardName = strtoupper($request->input('lastname') . ' ' . $request->input('names'));
        $model->Address = $request->input('Address1') . ' ' . $request->input('Address2') . ' ' . $request->input('Address3');
        $model->CardType = 'L'; // C=Cliente, L=Lead
        // return $model;



        if ($model->save()) {
            
            session()->flash('app_message', 'Client saved successfully');
            if($request->input('goOrder') != null){
                return redirect()->route('orders.create',['client_code'=>$model->CardCode,'client_name'=>$model->CardName,'new_client'=>true]);
            }
            return redirect()->route('clients.index');
            } else {
                session()->flash('app_message', 'Something is wrong while saving Client');
            }
        return redirect()->back();
    } /**
     * Show the form for editing the specified resource.
     *
     * @param  Edit  $request
     * @param  Client  $client
     * @return \Illuminate\Http\Response
     */
    public function edit(Edit $request, Client $client)
    {

        return view('pages.clients.edit', [
            'model' => $client,

            ]);
    }    /**
     * Update a existing resource in storage.
     *
     * @param  Update  $request
     * @param  Client  $client
     * @return \Illuminate\Http\Response
     */
    public function update(Update $request,Client $client)
    {
        $client->fill($request->all());

        if ($client->save()) {
            
            session()->flash('app_message', 'Client successfully updated');
            return redirect()->route('clients.index');
            } else {
                session()->flash('app_error', 'Something is wrong while updating Client');
            }
        return redirect()->back();
    }    /**
     * Delete a  resource from  storage.
     *
     * @param  Destroy  $request
     * @param  Client  $client
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Destroy $request, Client $client)
    {
        if ($client->delete()) {
                session()->flash('app_message', 'Client successfully deleted');
            } else {
                session()->flash('app_error', 'Error occurred while deleting Client');
            }

        return redirect()->back();
    }
}
